/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdfview;

import com.sun.pdfview.Cache;
import com.sun.pdfview.OutlineNode;
import com.sun.pdfview.PDFDestination;
import com.sun.pdfview.PDFObject;
import com.sun.pdfview.PDFPage;
import com.sun.pdfview.PDFParseException;
import com.sun.pdfview.PDFParser;
import com.sun.pdfview.PDFXref;
import com.sun.pdfview.PDFXrefEntry;
import com.sun.pdfview.action.GoToAction;
import com.sun.pdfview.action.PDFAction;
import com.sun.pdfview.decode.PDFDecoder;
import com.sun.pdfview.decrypt.EncryptionUnsupportedByPlatformException;
import com.sun.pdfview.decrypt.EncryptionUnsupportedByProductException;
import com.sun.pdfview.decrypt.IdentityDecrypter;
import com.sun.pdfview.decrypt.PDFAuthenticationFailureException;
import com.sun.pdfview.decrypt.PDFDecrypter;
import com.sun.pdfview.decrypt.PDFDecrypterFactory;
import com.sun.pdfview.decrypt.PDFPassword;
import com.sun.pdfview.decrypt.UnsupportedEncryptionException;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PDFFile {
    public static final int NUL_CHAR = 0;
    public static final int FF_CHAR = 12;
    private String versionString = "1.1";
    private int majorVersion = 1;
    private int minorVersion = 1;
    private static final String VERSION_COMMENT = "%PDF-";
    ByteBuffer fileBuf;
    PDFXrefEntry[] xrefEntries;
    PDFObject root = null;
    PDFObject encrypt = null;
    PDFObject info = null;
    Cache cache;
    private boolean printable = true;
    private boolean saveable = true;
    private PDFDecrypter defaultDecrypter = IdentityDecrypter.getInstance();
    private PDFObject fileIdentifier = null;

    public PDFFile(ByteBuffer buf) throws IOException {
        this(buf, null);
    }

    public PDFFile(ByteBuffer buf, PDFPassword password) throws IOException {
        this.fileBuf = buf;
        this.cache = new Cache();
        this.parseFile(password);
    }

    public boolean isPrintable() {
        return this.printable;
    }

    public boolean isSaveable() {
        return this.saveable;
    }

    public PDFObject getRoot() {
        return this.root;
    }

    public int getNumPages() {
        try {
            return this.root.getDictRef("Pages").getDictRef("Count").getIntValue();
        }
        catch (Exception ioe) {
            return 0;
        }
    }

    public String getStringMetadata(String name) throws IOException {
        if (this.info != null) {
            PDFObject meta = this.info.getDictRef(name);
            return meta != null ? meta.getTextStringValue() : null;
        }
        return null;
    }

    public Iterator<String> getMetadataKeys() throws IOException {
        if (this.info != null) {
            return this.info.getDictKeys();
        }
        return Collections.emptyList().iterator();
    }

    public synchronized PDFObject dereference(PDFXref ref, PDFDecrypter decrypter) throws IOException {
        int id = ref.getObjectNumber();
        if (id >= this.xrefEntries.length || id < 0) {
            return PDFObject.nullObj;
        }
        PDFXrefEntry entry = this.xrefEntries[id];
        if (entry == null || !entry.resolves(ref)) {
            return PDFObject.nullObj;
        }
        PDFObject obj = entry.getObject();
        if (obj != null) {
            return obj;
        }
        switch (entry.getType()) {
            case OBJ_IN_BODY: {
                int loc = entry.getOffset();
                if (loc < 0) {
                    return PDFObject.nullObj;
                }
                int startPos = this.fileBuf.position();
                this.fileBuf.position(loc);
                obj = this.readObject(this.fileBuf, ref.getObjectNumber(), ref.getGeneration(), decrypter);
                if (obj == null) {
                    obj = PDFObject.nullObj;
                }
                entry.setObject(obj);
                this.fileBuf.position(startPos);
                return obj;
            }
            case OBJ_IN_STREAM: {
                PDFObject stream = this.dereference(entry.getStream(), this.getDefaultDecrypter());
                if (stream == null || stream.getType() != 7 || !"ObjStm".equals(stream.getDictRef("Type").getStringValue())) {
                    throw new PDFParseException(entry.getStream().getObjectNumber() + " is not an object stream, but was referenced in " + "the xref stream as one");
                }
                ByteBuffer streamBuf = stream.getStreamBuffer();
                PDFXrefEntry streamSourceEntry = this.xrefEntries[entry.getStream().getObjectNumber()];
                int[] offsets = streamSourceEntry.getObjectIndexOffsets();
                if (offsets == null) {
                    offsets = new int[stream.getDictionary().get("N").getIntValue()];
                    int first = stream.getDictionary().get("First").getIntValue();
                    for (int i = 0; i < offsets.length; ++i) {
                        PDFObject objNum = this.readObject(streamBuf, -1, -1, IdentityDecrypter.getInstance());
                        offsets[i] = first + this.readObject(streamBuf, -1, -1, IdentityDecrypter.getInstance()).getIntValue();
                    }
                    streamSourceEntry.setObjectIndexOffsets(offsets);
                }
                if (entry.getOffset() < 0 || entry.getOffset() >= offsets.length) {
                    throw new PDFParseException("Xref references index that does not exist in stream");
                }
                streamBuf.position(offsets[entry.getOffset()]);
                obj = this.readObject(streamBuf, ref.getObjectNumber(), ref.getGeneration(), PDFDecoder.isEncrypted(stream) ? IdentityDecrypter.getInstance() : this.getDefaultDecrypter());
                if (obj == null) {
                    obj = PDFObject.nullObj;
                }
                entry.setObject(obj);
                return obj;
            }
            case FREE: {
                return PDFObject.nullObj;
            }
        }
        throw new UnsupportedOperationException("Don't know how to handle xref type " + (Object)((Object)entry.getType()));
    }

    public static boolean isWhiteSpace(int c) {
        switch (c) {
            case 0: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 32: {
                return true;
            }
        }
        return false;
    }

    public static boolean isDelimiter(int c) {
        switch (c) {
            case 37: 
            case 40: 
            case 41: 
            case 47: 
            case 60: 
            case 62: 
            case 91: 
            case 93: 
            case 123: 
            case 125: {
                return true;
            }
        }
        return false;
    }

    public static boolean isRegularCharacter(int c) {
        return !PDFFile.isWhiteSpace(c) && !PDFFile.isDelimiter(c);
    }

    private PDFObject readObject(ByteBuffer buf, int objNum, int objGen, PDFDecrypter decrypter) throws IOException {
        return this.readObject(buf, objNum, objGen, false, decrypter);
    }

    private PDFObject readObject(ByteBuffer buf, int objNum, int objGen, boolean numscan, PDFDecrypter decrypter) throws IOException {
        PDFObject obj = null;
        while (obj == null) {
            int c = this.nextNonWhitespaceChar(buf);
            if (c == 60) {
                c = buf.get();
                if (c == 60) {
                    obj = this.readDictionary(buf, objNum, objGen, decrypter);
                    continue;
                }
                buf.position(buf.position() - 1);
                obj = this.readHexString(buf, objNum, objGen, decrypter);
                continue;
            }
            if (c == 40) {
                obj = this.readLiteralString(buf, objNum, objGen, decrypter);
                continue;
            }
            if (c == 91) {
                obj = this.readArray(buf, objNum, objGen, decrypter);
                continue;
            }
            if (c == 47) {
                obj = this.readName(buf);
                continue;
            }
            if (c == 37) {
                this.readLine(buf);
                continue;
            }
            if (c >= 48 && c <= 57 || c == 45 || c == 43 || c == 46) {
                obj = this.readNumber(buf, (char)c);
                if (numscan) continue;
                int startPos = buf.position();
                PDFObject testnum = this.readObject(buf, -1, -1, true, decrypter);
                if (testnum != null && testnum.getType() == 2) {
                    PDFObject testR = this.readObject(buf, -1, -1, true, decrypter);
                    if (testR != null && testR.getType() == 9 && testR.getStringValue().equals("R")) {
                        PDFXref xref = new PDFXref(obj.getIntValue(), testnum.getIntValue());
                        obj = new PDFObject(this, xref);
                        continue;
                    }
                    if (testR != null && testR.getType() == 9 && testR.getStringValue().equals("obj")) {
                        obj = this.readObjectDescription(buf, obj.getIntValue(), testnum.getIntValue(), decrypter);
                        continue;
                    }
                    buf.position(startPos);
                    continue;
                }
                buf.position(startPos);
                continue;
            }
            if (c >= 97 && c <= 122 || c >= 65 && c <= 90) {
                obj = this.readKeyword(buf, (char)c);
                continue;
            }
            buf.position(buf.position() - 1);
            break;
        }
        return obj;
    }

    private int nextNonWhitespaceChar(ByteBuffer buf) {
        byte c;
        while (PDFFile.isWhiteSpace(c = buf.get())) {
        }
        return c;
    }

    private void consumeWhitespace(ByteBuffer buf) {
        this.nextNonWhitespaceChar(buf);
        buf.position(buf.position() - 1);
    }

    private boolean nextItemIs(ByteBuffer buf, String match) throws IOException {
        int c = this.nextNonWhitespaceChar(buf);
        for (int i = 0; i < match.length(); ++i) {
            if (i > 0) {
                c = buf.get();
            }
            if (c == match.charAt(i)) continue;
            return false;
        }
        return true;
    }

    private void processVersion(String versionString) {
        try {
            StringTokenizer tokens = new StringTokenizer(versionString, ".");
            this.majorVersion = Integer.parseInt(tokens.nextToken());
            this.minorVersion = Integer.parseInt(tokens.nextToken());
            this.versionString = versionString;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public String getVersionString() {
        return this.versionString;
    }

    private PDFObject readDictionary(ByteBuffer buf, int objNum, int objGen, PDFDecrypter decrypter) throws IOException {
        PDFObject name;
        HashMap<String, PDFObject> hm = new HashMap<String, PDFObject>();
        while ((name = this.readObject(buf, objNum, objGen, decrypter)) != null) {
            if (name.getType() != 4) {
                throw new PDFParseException("First item in dictionary must be a /Name.  (Was " + name + ")");
            }
            PDFObject value = this.readObject(buf, objNum, objGen, decrypter);
            if (value == null) continue;
            hm.put(name.getStringValue(), value);
        }
        if (!this.nextItemIs(buf, ">>")) {
            throw new PDFParseException("End of dictionary wasn't '>>'");
        }
        return new PDFObject(this, 6, hm);
    }

    private int readHexDigit(ByteBuffer buf) throws IOException {
        int a = this.nextNonWhitespaceChar(buf);
        switch (a) {
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                a -= 48;
                break;
            }
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: {
                a -= 87;
                break;
            }
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: {
                a -= 55;
                break;
            }
            default: {
                a = -1;
            }
        }
        return a;
    }

    private int readHexPair(ByteBuffer buf) throws IOException {
        int first = this.readHexDigit(buf);
        if (first < 0) {
            buf.position(buf.position() - 1);
            return -1;
        }
        int second = this.readHexDigit(buf);
        if (second < 0) {
            buf.position(buf.position() - 1);
            return first << 4;
        }
        return (first << 4) + second;
    }

    private PDFObject readHexString(ByteBuffer buf, int objNum, int objGen, PDFDecrypter decrypter) throws IOException {
        int val;
        StringBuffer sb = new StringBuffer();
        while ((val = this.readHexPair(buf)) >= 0) {
            sb.append((char)val);
        }
        if (buf.get() != 62) {
            throw new PDFParseException("Bad character in Hex String");
        }
        return new PDFObject(this, 3, decrypter.decryptString(objNum, objGen, sb.toString()));
    }

    private PDFObject readLiteralString(ByteBuffer buf, int objNum, int objGen, PDFDecrypter decrypter) throws IOException {
        int parencount = 1;
        StringBuffer sb = new StringBuffer();
        while (parencount > 0) {
            int c = buf.get() & 0xFF;
            if (c == 40) {
                ++parencount;
            } else if (c == 41) {
                if (--parencount == 0) {
                    c = -1;
                    break;
                }
            } else if (c == 92) {
                c = buf.get() & 0xFF;
                if (c >= 48 && c < 56) {
                    int val = 0;
                    for (int count = 0; c >= 48 && c < 56 && count < 3; ++count) {
                        val = val * 8 + c - 48;
                        c = buf.get() & 0xFF;
                    }
                    buf.position(buf.position() - 1);
                    c = val;
                } else if (c == 110) {
                    c = 10;
                } else if (c == 114) {
                    c = 13;
                } else if (c == 116) {
                    c = 9;
                } else if (c == 98) {
                    c = 8;
                } else if (c == 102) {
                    c = 12;
                } else if (c == 13) {
                    c = buf.get() & 0xFF;
                    if (c != 10) {
                        buf.position(buf.position() - 1);
                    }
                    c = -1;
                } else if (c == 10) {
                    c = -1;
                }
            }
            if (c < 0) continue;
            sb.append((char)c);
        }
        return new PDFObject(this, 3, decrypter.decryptString(objNum, objGen, sb.toString()));
    }

    private String readLine(ByteBuffer buf) {
        StringBuffer sb = new StringBuffer();
        while (buf.remaining() > 0) {
            char c = (char)buf.get();
            if (c == '\r') {
                char n;
                if (buf.remaining() <= 0 || (n = (char)buf.get(buf.position())) != '\n') break;
                buf.get();
                break;
            }
            if (c == '\n') break;
            sb.append(c);
        }
        return sb.toString();
    }

    private PDFObject readArray(ByteBuffer buf, int objNum, int objGen, PDFDecrypter decrypter) throws IOException {
        PDFObject obj;
        ArrayList<PDFObject> ary = new ArrayList<PDFObject>();
        while ((obj = this.readObject(buf, objNum, objGen, decrypter)) != null) {
            ary.add(obj);
        }
        if (buf.get() != 93) {
            throw new PDFParseException("Array should end with ']'");
        }
        PDFObject[] objlist = new PDFObject[ary.size()];
        for (int i = 0; i < objlist.length; ++i) {
            objlist[i] = (PDFObject)ary.get(i);
        }
        return new PDFObject(this, 5, objlist);
    }

    private PDFObject readName(ByteBuffer buf) throws IOException {
        int c;
        StringBuffer sb = new StringBuffer();
        while (PDFFile.isRegularCharacter(c = buf.get()) && (c >= 33 || c <= 126)) {
            if (c == 35 && this.majorVersion != 1 && this.minorVersion != 1) {
                int hex = this.readHexPair(buf);
                if (hex >= 0) {
                    c = hex;
                } else {
                    throw new PDFParseException("Bad #hex in /Name");
                }
            }
            sb.append((char)c);
        }
        buf.position(buf.position() - 1);
        return new PDFObject(this, 4, sb.toString());
    }

    private PDFObject readNumber(ByteBuffer buf, char start) throws IOException {
        double value;
        boolean neg = start == '-';
        boolean sawdot = start == '.';
        double dotmult = sawdot ? 0.1 : 1.0;
        double d = value = start >= '0' && start <= '9' ? (double)(start - 48) : 0.0;
        while (true) {
            byte c;
            if ((c = buf.get()) == 46) {
                if (sawdot) {
                    throw new PDFParseException("Can't have two '.' in a number");
                }
                sawdot = true;
                dotmult = 0.1;
                continue;
            }
            if (c < 48 || c > 57) break;
            int val = c - 48;
            if (sawdot) {
                value += (double)val * dotmult;
                dotmult *= 0.1;
                continue;
            }
            value = value * 10.0 + (double)val;
        }
        buf.position(buf.position() - 1);
        if (neg) {
            value = -value;
        }
        return new PDFObject(this, 2, new Double(value));
    }

    private PDFObject readKeyword(ByteBuffer buf, char start) throws IOException {
        byte c;
        StringBuffer sb = new StringBuffer(String.valueOf(start));
        while (PDFFile.isRegularCharacter(c = buf.get())) {
            sb.append((char)c);
        }
        buf.position(buf.position() - 1);
        return new PDFObject(this, 9, sb.toString());
    }

    private PDFObject readObjectDescription(ByteBuffer buf, int objNum, int objGen, PDFDecrypter decrypter) throws IOException {
        String endcheck;
        long debugpos = buf.position();
        PDFObject obj = this.readObject(buf, objNum, objGen, decrypter);
        PDFObject endkey = this.readObject(buf, objNum, objGen, decrypter);
        if (endkey.getType() != 9) {
            throw new PDFParseException("Expected 'stream' or 'endobj'");
        }
        if (obj.getType() == 6 && endkey.getStringValue().equals("stream")) {
            this.readLine(buf);
            ByteBuffer data = this.readStream(buf, obj);
            if (data == null) {
                data = ByteBuffer.allocate(0);
            }
            obj.setStream(data);
            endkey = this.readObject(buf, objNum, objGen, decrypter);
        }
        if ((endcheck = endkey.getStringValue()) == null || !endcheck.equals("endobj")) {
            System.out.println("WARNING: object at " + debugpos + " didn't end with 'endobj'");
        }
        obj.setObjectId(objNum, objGen);
        return obj;
    }

    private ByteBuffer readStream(ByteBuffer buf, PDFObject dict) throws IOException {
        PDFObject lengthObj = dict.getDictRef("Length");
        int length = -1;
        if (lengthObj != null) {
            length = lengthObj.getIntValue();
        }
        if (length < 0) {
            throw new PDFParseException("Unknown length for stream");
        }
        int start = buf.position();
        ByteBuffer streamBuf = buf.slice();
        streamBuf.limit(length);
        buf.position(buf.position() + length);
        int ending = buf.position();
        if (!this.nextItemIs(buf, "endstream")) {
            System.out.println("read " + length + " chars from " + start + " to " + ending);
            throw new PDFParseException("Stream ended inappropriately");
        }
        return streamBuf;
    }

    private void readTrailersAndXrefs(PDFPassword password) throws IOException, PDFAuthenticationFailureException, EncryptionUnsupportedByProductException, EncryptionUnsupportedByPlatformException {
        boolean furtherCrossrefsToRead = true;
        while (furtherCrossrefsToRead) {
            PDFObject header = this.readObject(this.fileBuf, -1, -1, IdentityDecrypter.getInstance());
            if (header.getType() == 9 && "xref".equals(header.getStringValue())) {
                furtherCrossrefsToRead = this.readCrossrefTableAndTrailer(password);
                continue;
            }
            if (this.isXrefStream(header)) {
                furtherCrossrefsToRead = this.readCrossrefStream(header, true);
                continue;
            }
            throw new PDFParseException("Expected xref table or xref stream, but found " + header);
        }
        if (this.root == null) {
            throw new PDFParseException("No /Root key found in trailer dictionary");
        }
        if (this.root.getDictRef("Version") != null) {
            this.processVersion(this.root.getDictRef("Version").getStringValue());
        }
        if (this.encrypt != null) {
            this.defaultDecrypter = PDFDecrypterFactory.createDecryptor(this.encrypt, this.fileIdentifier, password);
            PDFObject permissions = this.encrypt.getDictRef("P");
            if (permissions != null && !this.defaultDecrypter.isOwnerAuthorised()) {
                int perms;
                int n = perms = permissions != null ? permissions.getIntValue() : 0;
                if (permissions != null) {
                    this.printable = (perms & 4) != 0;
                    this.saveable = (perms & 0x10) != 0;
                }
            }
        }
        this.root.dereference();
    }

    private boolean isXrefStream(PDFObject header) throws IOException {
        return header.getType() == 7 && "XRef".equals(header.getDictRef("Type").getStringValue());
    }

    private boolean readCrossrefTableAndTrailer(PDFPassword password) throws IOException {
        PDFObject headerObject;
        while ((headerObject = this.readObject(this.fileBuf, -1, -1, IdentityDecrypter.getInstance())).getType() == 2) {
            int objNumStart = headerObject.getIntValue();
            PDFObject sizeObj = this.readObject(this.fileBuf, -1, -1, IdentityDecrypter.getInstance());
            if (sizeObj.getType() != 2) {
                throw new PDFParseException("Expected number for length of xref table");
            }
            int numEntries = sizeObj.getIntValue();
            int lastObjNum = objNumStart + numEntries;
            this.ensureXrefEntriesCapacity(lastObjNum + 1);
            this.consumeWhitespace(this.fileBuf);
            byte[] refline = new byte[20];
            for (int objNum = objNumStart; objNum < lastObjNum; ++objNum) {
                PDFXrefEntry entry;
                this.fileBuf.get(refline);
                if (this.xrefEntries[objNum] != null) continue;
                byte entryType = refline[17];
                if (entryType == 110) {
                    int offset = Integer.parseInt(new String(refline, 0, 10));
                    int generation = Integer.parseInt(new String(refline, 11, 5));
                    PDFXref ref = new PDFXref(objNum, generation);
                    entry = PDFXrefEntry.toBodyObject(generation, offset);
                } else if (entryType == 102) {
                    entry = PDFXrefEntry.forFreedObject();
                } else {
                    throw new PDFParseException("Unknown xref entry type: " + entryType);
                }
                this.xrefEntries[objNum] = entry;
            }
        }
        if (headerObject.getType() != 9 || !"trailer".equals(headerObject.getStringValue())) {
            throw new PDFParseException("Expected to find trailer immediately after xref table, but found " + headerObject + " instead");
        }
        PDFObject trailerdict = this.readObject(this.fileBuf, -1, -1, IdentityDecrypter.getInstance());
        if (trailerdict.getType() != 6) {
            throw new PDFParseException("Expected dictionary after \"trailer\"");
        }
        return this.processTrailerDict(trailerdict, false, true);
    }

    private boolean processTrailerDict(PDFObject trailerdict, boolean xrefStreamSource, boolean followPrev) throws IOException {
        PDFObject xrefStm;
        if (this.root == null) {
            this.root = trailerdict.getDictRef("Root");
            if (this.root != null) {
                this.root.setObjectId(-1, -1);
            }
        }
        if (this.fileIdentifier == null) {
            this.fileIdentifier = trailerdict.getDictRef("ID");
        }
        if (this.encrypt == null) {
            this.encrypt = trailerdict.getDictRef("Encrypt");
            if (this.encrypt != null) {
                this.encrypt.setObjectId(-1, -1);
            }
        }
        if (this.info == null) {
            this.info = trailerdict.getDictRef("Info");
            if (this.info != null) {
                if (!this.info.isIndirect()) {
                    throw new PDFParseException("Info in trailer must be an indirect reference");
                }
                this.info.setObjectId(-1, -1);
            }
        }
        if (!xrefStreamSource && (xrefStm = trailerdict.getDictRef("XRefStm")) != null) {
            this.fileBuf.position(xrefStm.getIntValue());
            this.readCrossrefStream(null, false);
        }
        PDFObject prevloc = null;
        if (followPrev && (prevloc = trailerdict.getDictRef("Prev")) != null) {
            this.fileBuf.position(prevloc.getIntValue());
        }
        return prevloc != null;
    }

    private boolean readCrossrefStream(PDFObject xrefStream, boolean followPrev) throws IOException {
        if (xrefStream == null && !this.isXrefStream(xrefStream = this.readObject(this.fileBuf, -1, -1, IdentityDecrypter.getInstance()))) {
            throw new PDFParseException("Object found at offset for cross reference stream is not a cross reference stream");
        }
        int size = xrefStream.getDictRef("Size").getIntValue();
        this.ensureXrefEntriesCapacity(size);
        PDFObject[] wObjs = xrefStream.getDictRef("W").getArray();
        int[] fieldLengths = new int[3];
        int entryLength = 0;
        for (int i = 0; i < 3; ++i) {
            fieldLengths[i] = wObjs[i].getIntValue();
            entryLength += fieldLengths[i];
        }
        PDFObject indexObj = xrefStream.getDictRef("Index");
        PDFObject[] index = indexObj != null ? indexObj.getArray() : new PDFObject[]{new PDFObject(0), new PDFObject(size)};
        ByteBuffer table = xrefStream.getStreamBuffer();
        for (int i = 0; i < index.length; i += 2) {
            int start = index[i].getIntValue();
            int end = start + index[i + 1].getIntValue();
            for (int objNum = start; objNum < end; ++objNum) {
                if (this.xrefEntries[objNum] == null) {
                    PDFXrefEntry.Type type = fieldLengths[0] == 0 ? PDFXrefEntry.Type.OBJ_IN_BODY : PDFXrefEntry.Type.forTypeField(this.readInt(table, fieldLengths[0]));
                    int field2 = this.readInt(table, fieldLengths[1]);
                    int field3 = this.readInt(table, fieldLengths[2]);
                    this.xrefEntries[objNum] = type.makeXrefStreamEntry(field2, field3);
                    continue;
                }
                table.position(table.position() + entryLength);
            }
        }
        return this.processTrailerDict(xrefStream, true, followPrev);
    }

    private int readInt(ByteBuffer table, int numBytes) {
        int val = 0;
        while (numBytes-- > 0) {
            int b = table.get() & 0xFF;
            val = val << 8 | b;
        }
        return val;
    }

    private void ensureXrefEntriesCapacity(int size) {
        if (this.xrefEntries == null || this.xrefEntries.length < size) {
            PDFXrefEntry[] newXrefEntries = new PDFXrefEntry[size];
            if (this.xrefEntries != null) {
                System.arraycopy(this.xrefEntries, 0, newXrefEntries, 0, this.xrefEntries.length);
            }
            this.xrefEntries = newXrefEntries;
        }
    }

    private void parseFile(PDFPassword password) throws IOException {
        this.fileBuf.rewind();
        String versionLine = this.readLine(this.fileBuf);
        if (versionLine.startsWith(VERSION_COMMENT)) {
            this.processVersion(versionLine.substring(VERSION_COMMENT.length()));
        }
        this.fileBuf.rewind();
        this.fileBuf.position(this.fileBuf.limit() - 1);
        if (!this.backscan(this.fileBuf, "startxref")) {
            throw new PDFParseException("This may not be a PDF File");
        }
        int postStartXrefPos = this.fileBuf.position();
        if (!PDFFile.isWhiteSpace(this.fileBuf.get())) {
            throw new PDFParseException("Found suspicious startxref without trialing whitespace");
        }
        StringBuilder xrefBuf = new StringBuilder();
        char c = (char)this.nextNonWhitespaceChar(this.fileBuf);
        while (c >= '0' && c <= '9') {
            xrefBuf.append(c);
            c = (char)this.fileBuf.get();
        }
        int xrefpos = Integer.parseInt(xrefBuf.toString());
        this.fileBuf.position(xrefpos);
        try {
            this.readTrailersAndXrefs(password);
        }
        catch (UnsupportedEncryptionException e) {
            throw new PDFParseException(e.getMessage(), e);
        }
    }

    private boolean backscan(ByteBuffer buf, String scanToken) {
        byte[] scanbuf = new byte[32];
        if (scanToken.length() * 2 > scanbuf.length) {
            throw new IllegalArgumentException("scanToken is too long - adjust buffer length");
        }
        int scanPos = buf.position() - scanbuf.length;
        if (scanPos < 0) {
            scanbuf = new byte[buf.position()];
            scanPos = 0;
        }
        while (scanPos >= 0) {
            buf.position(scanPos);
            buf.get(scanbuf);
            String scans = new String(scanbuf);
            int loc = scans.lastIndexOf(scanToken);
            if (loc > 0) {
                buf.position(scanPos + loc + scanToken.length());
                return true;
            }
            int newScanPos = scanPos - scanbuf.length + scanToken.length() - 1;
            if (newScanPos < 0) {
                scanPos = scanPos == 0 ? -1 : newScanPos;
                continue;
            }
            scanPos = newScanPos;
        }
        return false;
    }

    public OutlineNode getOutline() throws IOException {
        PDFObject oroot = this.root.getDictRef("Outlines");
        OutlineNode work = null;
        OutlineNode outline = null;
        if (oroot != null) {
            PDFObject scan = oroot.getDictRef("First");
            outline = work = new OutlineNode("<top>");
            while (scan != null) {
                PDFObject kid;
                String title = scan.getDictRef("Title").getTextStringValue();
                OutlineNode build = new OutlineNode(title);
                work.add(build);
                PDFAction action = null;
                PDFObject actionObj = scan.getDictRef("A");
                if (actionObj != null) {
                    action = PDFAction.getAction(actionObj, this.getRoot());
                } else {
                    PDFObject destObj = scan.getDictRef("Dest");
                    if (destObj != null) {
                        try {
                            PDFDestination dest = PDFDestination.getDestination(destObj, this.getRoot());
                            action = new GoToAction(dest);
                        }
                        catch (IOException ioe) {
                            // empty catch block
                        }
                    }
                }
                if (action != null) {
                    build.setAction(action);
                }
                if ((kid = scan.getDictRef("First")) != null) {
                    work = build;
                    scan = kid;
                    continue;
                }
                PDFObject next = scan.getDictRef("Next");
                while (next == null) {
                    scan = scan.getDictRef("Parent");
                    next = scan.getDictRef("Next");
                    if ((work = (OutlineNode)work.getParent()) != null) continue;
                }
                scan = next;
            }
        }
        return outline;
    }

    public int getPageNumber(PDFObject page) throws IOException {
        PDFObject parent;
        PDFObject typeObj;
        if (page.getType() == 5) {
            page = page.getAt(0);
        }
        if ((typeObj = page.getDictRef("Type")) == null || !typeObj.getStringValue().equals("Page")) {
            return 0;
        }
        int count = 0;
        while ((parent = page.getDictRef("Parent")) != null) {
            PDFObject[] kids = parent.getDictRef("Kids").getArray();
            for (int i = 0; i < kids.length && !kids[i].equals(page); ++i) {
                PDFObject kcount = kids[i].getDictRef("Count");
                if (kcount != null) {
                    count += kcount.getIntValue();
                    continue;
                }
                ++count;
            }
            page = parent;
        }
        return count;
    }

    public PDFPage getPage(int pagenum) {
        return this.getPage(pagenum, false);
    }

    public PDFPage getPage(int pagenum, boolean wait) {
        Integer key = new Integer(pagenum);
        HashMap<String, PDFObject> resources = null;
        PDFObject pageObj = null;
        boolean needread = false;
        PDFPage page = this.cache.getPage(key);
        PDFParser parser = this.cache.getPageParser(key);
        if (page == null) {
            try {
                resources = new HashMap<String, PDFObject>();
                PDFObject topPagesObj = this.root.getDictRef("Pages");
                pageObj = this.findPage(topPagesObj, 0, pagenum, resources);
                if (pageObj == null) {
                    return null;
                }
                page = this.createPage(pagenum, pageObj);
                byte[] stream = this.getContents(pageObj);
                parser = new PDFParser(page, stream, resources);
                this.cache.addPage(key, page, parser);
            }
            catch (IOException ioe) {
                System.out.println("GetPage inner loop:");
                ioe.printStackTrace();
                return null;
            }
        }
        if (parser != null && !parser.isFinished()) {
            parser.go(wait);
        }
        return page;
    }

    public void stop(int pageNum) {
        PDFParser parser = this.cache.getPageParser(new Integer(pageNum));
        if (parser != null) {
            parser.stop();
        }
    }

    private byte[] getContents(PDFObject pageObj) throws IOException {
        PDFObject contentsObj = pageObj.getDictRef("Contents");
        if (contentsObj == null) {
            throw new IOException("No page contents!");
        }
        PDFObject[] contents = contentsObj.getArray();
        if (contents.length == 1) {
            return contents[0].getStream();
        }
        int len = 0;
        for (int i = 0; i < contents.length; ++i) {
            byte[] data = contents[i].getStream();
            if (data == null) {
                throw new PDFParseException("No stream on content " + i + ": " + contents[i]);
            }
            len += data.length;
        }
        byte[] stream = new byte[len];
        len = 0;
        for (int i = 0; i < contents.length; ++i) {
            byte[] data = contents[i].getStream();
            System.arraycopy(data, 0, stream, len, data.length);
            len += data.length;
        }
        return stream;
    }

    private PDFPage createPage(int pagenum, PDFObject pageObj) throws IOException {
        PDFObject rotateObj;
        PDFObject cropboxObj;
        int rotation = 0;
        Rectangle2D mediabox = null;
        Rectangle2D cropbox = null;
        PDFObject mediaboxObj = this.getInheritedValue(pageObj, "MediaBox");
        if (mediaboxObj != null) {
            mediabox = PDFFile.parseNormalisedRectangle(mediaboxObj);
        }
        if ((cropboxObj = this.getInheritedValue(pageObj, "CropBox")) != null) {
            cropbox = PDFFile.parseNormalisedRectangle(cropboxObj);
        }
        if ((rotateObj = this.getInheritedValue(pageObj, "Rotate")) != null) {
            rotation = rotateObj.getIntValue();
        }
        Rectangle2D bbox = cropbox == null ? mediabox : cropbox;
        return new PDFPage(pagenum, bbox, rotation, this.cache);
    }

    private PDFObject findPage(PDFObject pagedict, int start, int getPage, Map<String, PDFObject> resources) throws IOException {
        PDFObject typeObj;
        PDFObject rsrcObj = pagedict.getDictRef("Resources");
        if (rsrcObj != null) {
            resources.putAll(rsrcObj.getDictionary());
        }
        if ((typeObj = pagedict.getDictRef("Type")) != null && typeObj.getStringValue().equals("Page")) {
            return pagedict;
        }
        PDFObject kidsObj = pagedict.getDictRef("Kids");
        if (kidsObj != null) {
            PDFObject[] kids = kidsObj.getArray();
            for (int i = 0; i < kids.length; ++i) {
                int count = 1;
                PDFObject countItem = kids[i].getDictRef("Count");
                if (countItem != null) {
                    count = countItem.getIntValue();
                }
                if (start + count >= getPage) {
                    return this.findPage(kids[i], start, getPage, resources);
                }
                start += count;
            }
        }
        return null;
    }

    private PDFObject getInheritedValue(PDFObject pageObj, String propName) throws IOException {
        PDFObject propObj = pageObj.getDictRef(propName);
        if (propObj != null) {
            return propObj;
        }
        PDFObject parentObj = pageObj.getDictRef("Parent");
        if (parentObj != null) {
            return this.getInheritedValue(parentObj, propName);
        }
        return null;
    }

    public static Rectangle2D parseNormalisedRectangle(PDFObject obj) throws IOException {
        if (obj != null) {
            if (obj.getType() == 5) {
                PDFObject[] bounds = obj.getArray();
                if (bounds.length == 4) {
                    double maxY;
                    double minY;
                    double maxX;
                    double minX;
                    double x0 = bounds[0].getDoubleValue();
                    double y0 = bounds[1].getDoubleValue();
                    double x1 = bounds[2].getDoubleValue();
                    double y1 = bounds[3].getDoubleValue();
                    if (x0 < x1) {
                        minX = x0;
                        maxX = x1;
                    } else {
                        minX = x1;
                        maxX = x0;
                    }
                    if (y0 < y1) {
                        minY = y0;
                        maxY = y1;
                    } else {
                        minY = y1;
                        maxY = y0;
                    }
                    return new Rectangle2D.Double(minX, minY, Math.abs(maxX - minX), Math.abs(maxY - minY));
                }
                throw new PDFParseException("Rectangle definition didn't have 4 elements");
            }
            throw new PDFParseException("Rectangle definition not an array");
        }
        throw new PDFParseException("Rectangle not present");
    }

    public PDFDecrypter getDefaultDecrypter() {
        return this.defaultDecrypter;
    }
}

